document.getElementById('sign').addEventListener('submit', async function(e) {
  e.preventDefault();

  const device = document.getElementById('device').value;
  const src = document.getElementById('src').value;
  const password = document.getElementById('password').value;

  const data = { device, src, password };
  const resultDiv = document.getElementById('result'); // div для вывода

  try 
  {
    const response = await fetch('http://localhost:5000/sign', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(data)
    });

    // Проверка ответа сервера
    if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);

    const result = await response.json();
    console.log(result); // Исправлено на console.log

    // Красивая и понятная визуализация ответа сервера
    const message = result.code;
    const tokenID = result.tokenID;
    const serial = result.serial;
    const owner = result.owner;
    const key = result.publicKey;
    const sign = result.sign;

    resultDiv.className = 'success'; // класс для успешного сообщения
    resultDiv.innerHTML = `
      <p><strong>tokenID:</strong> ${tokenID}</p>
      <p><strong>owner:</strong> ${owner}</p>
      <p><strong>publicKey:</strong> ${key}</p>
     <p><strong>serial:</strong> ${serial}</p>
      <p><strong>Sign:</strong> ${sign}</p>

    `;
  }

  catch (error) {
    resultDiv.className = 'error'; 
    resultDiv.innerHTML = `<p><strong>Ошибка при отправке данных:</strong> ${error.message}</p>`;
  }

});